<?php
session_start();
if (!isset($_SESSION['login'])) {
    header("Location: login.php");
    exit;
}

include 'koneksi.php'; // pastikan variabel koneksi: $conn

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$isEdit = $id > 0;


// Default value
$judul = $konten = $kategori = $status = $gambarLama = "";

if ($isEdit) {
    $stmt = $conn->prepare("SELECT * FROM artikel WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows === 0) {
        die('Artikel tidak ditemukan');
    }
    $row = $result->fetch_assoc();
    $judul = $row['judul'];
    $konten = $row['konten'];
    $kategori = $row['kategori'];
    $status = $row['status'];
    $gambarLama = $row['gambar'];
}

// ===== SIMPAN DATA =====
if (isset($_POST['simpan'])) {
    $judul = $_POST['judul'];
    $konten = $_POST['konten'];
    $kategori = $_POST['kategori'];
    $status = $_POST['status'];

    if (!is_dir('uploads')) {
    mkdir('uploads', 0777, true);
}



    // Upload gambar
    $gambar = $gambarLama;
    if (!empty($_FILES['gambar']['name'])) {
        $namaFile = time() . '_' . $_FILES['gambar']['name'];
        $tmp = $_FILES['gambar']['tmp_name'];
        move_uploaded_file($tmp, 'uploads/' . $namaFile);
        $gambar = $namaFile;
    }

    if ($isEdit) {
    $stmt = $conn->prepare(
        "UPDATE artikel SET judul=?, konten=?, kategori=?, status=?, gambar=? WHERE id=?"
    );
    $stmt->bind_param("sssssi", $judul, $konten, $kategori, $status, $gambar, $id);
} else {
    $stmt = $conn->prepare(
        "INSERT INTO artikel (judul, konten, kategori, status, gambar, tanggal)
         VALUES (?,?,?,?,?,NOW())"
    );
    $stmt->bind_param("sssss", $judul, $konten, $kategori, $status, $gambar);
}
$stmt->execute();


    header("Location: artikel.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title><?= $isEdit ? 'Edit' : 'Tambah' ?> Artikel</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="css/artikel.css">
    <style>
        .form-card{background:#fff;padding:2rem;border-radius:16px;box-shadow:var(--shadow);max-width:900px}
        .form-group{margin-bottom:1.2rem}
        .form-group label{font-weight:600;display:block;margin-bottom:.4rem}
        .form-group input,.form-group select,.form-group textarea{width:100%;padding:.7rem;border:1px solid #e5e7eb;border-radius:10px}
        textarea{min-height:180px;resize:vertical}
        .form-actions{display:flex;gap:1rem}
        .btn-secondary{background:#e5e7eb;color:#111}
    </style>
</head>
<body>

<div class="content" style="margin-left:260px">
    <h1><?= $isEdit ? 'Edit' : 'Tambah' ?> Artikel</h1>
    <p style="margin-bottom:1.5rem;color:var(--text-muted)">Isi data artikel di bawah ini</p>

    <div class="form-card">
        <form method="post" enctype="multipart/form-data">
            <div class="form-group">
                <label>Judul Artikel</label>
                <input type="text" name="judul" value="<?= htmlspecialchars($judul) ?>" required>
            </div>

            <div class="form-group">
                <label>Kategori</label>
                <select name="kategori" required>
                    <option value="">-- Pilih --</option>
                    <option value="Edukasi" <?= $kategori=='Edukasi'?'selected':'' ?>>Edukasi</option>
                    <option value="Berita" <?= $kategori=='Berita'?'selected':'' ?>>Berita</option>
                    <option value="Teknologi" <?= $kategori=='Teknologi'?'selected':'' ?>>Teknologi</option>
                </select>
            </div>

            <div class="form-group">
                <label>Status</label>
                <select name="status">
                    <option value="published" <?= $status=='published'?'selected':'' ?>>Published</option>
                    <option value="draft" <?= $status=='draft'?'selected':'' ?>>Draft</option>
                </select>
            </div>

            <div class="form-group">
                <label>Konten</label>
                <textarea name="konten" required><?= htmlspecialchars($konten) ?></textarea>
            </div>

            <div class="form-group">
                <label>Gambar</label>
                <input type="file" name="gambar">
                <?php if ($gambarLama): ?>
                    <small>Gambar saat ini: <?= $gambarLama ?></small>
                <?php endif; ?>
            </div>

            <div class="form-actions">
                <button type="submit" name="simpan" class="btn btn-add">Simpan</button>
                <a href="artikel.php" class="btn btn-secondary">Batal</a>
            </div>
        </form>
    </div>
</div>

</body>
</html>
