<?php
session_start();
if (!isset($_SESSION['login'])) {
    header("Location: login.php");
    exit;
}

include 'koneksi.php';

// UBAH $koneksi menjadi $conn sesuai dengan file koneksi.php Anda
$data = mysqli_query($conn, "SELECT * FROM kontak ORDER BY id DESC"); 

if (!$data) {
    die("Query Error: " . mysqli_error($conn));
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pesan Masuk - WTC Admin</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="css/kontak.css">
</head>
<body>

<?php include 'sidebar.php'; ?>

<div class="content">
    <header class="topbar">
        <div class="header-left">
            <h1>Pesan Masuk</h1>
            <p>Kelola pesan dan masukan dari pengunjung website</p>
        </div>
        <div class="user-profile">
            <div class="user-info">
                <span><?= htmlspecialchars($_SESSION['username']); ?></span>
                <small>Administrator</small>
            </div>
            <img src="https://ui-avatars.com/api/?name=<?= $_SESSION['username']; ?>&background=3b82f6&color=fff" alt="Avatar">
        </div>
    </header>

    <div class="table-container">
        <table class="modern-table">
            <thead>
    <tr>
        <th width="50">No</th>
        <th width="180">Nama pengirim</th>
        <th width="200">Email</th>
        <th width="140">No.hp</th>
        <th>Isi Pesan</th>
        <th width="150">Tanggal</th>
        <th width="100" class="text-center">Aksi</th>
    </tr>
</thead>

           <tbody>
<?php 
$no = 1; 
while ($row = mysqli_fetch_assoc($data)): 
?>
<tr>
    <td><?= $no++; ?></td>

    <td><?= htmlspecialchars($row['nama']); ?></td>

    <td><?= htmlspecialchars($row['email']); ?></td>

    <td><?= htmlspecialchars($row['no_hp']); ?></td>

    <td>
        <div class="message-preview">
            <?= htmlspecialchars($row['pesan']); ?>
        </div>
    </td>

    <td>
        <span class="date-tag">
            <i class="far fa-calendar-alt"></i>
            <?= date('d M Y', strtotime($row['tanggal'])); ?>
        </span>
    </td>

    <td class="text-center">
        <a href="hapus_pesan.php?id=<?= $row['id']; ?>"
           class="btn-delete"
           title="Hapus Pesan"
           onclick="return confirm('Yakin ingin menghapus pesan ini?')">
            <i class="fas fa-trash-alt"></i>
        </a>
    </td>
</tr>
<?php endwhile; ?>

<?php if (mysqli_num_rows($data) == 0): ?>
<tr>
    <td colspan="7" style="text-align:center; padding:3rem; color:#64748b;">
        <i class="fas fa-inbox fa-3x" style="display:block; margin-bottom:1rem; opacity:.5;"></i>
        Belum ada pesan masuk.
    </td>
</tr>
<?php endif; ?>
</tbody>

        </table>
    </div>
</div>

</body>
</html>